#include <bits/stdc++.h>

using namespace std;

struct Point {
 
    long long x, y;
 
    bool operator<(const Point& p) const {
        return x < p.x || (x == p.x && y < p.y);
    }
    bool operator==(const Point& p) const {
        return x == p.x && y == p.y;
    }
    bool operator!=(const Point& p) const {
        return x != p.x || y != p.y;
    }
};
long long cross_product(Point O, Point A, Point B)
{
    return (A.x - O.x) * (B.y - O.y)
           - (A.y - O.y) * (B.x - O.x);
}
vector<Point> convex_hull(vector<Point> A)
{
    int n = A.size(), k = 0;

    if (n < 3)
        return A;
 
    vector<Point> ans(2 * n);
    for (int i = 0; i < n; ++i) {
        while (k >= 2 && cross_product(ans[k - 2], ans[k - 1], A[i])<= 0)
            k--;
        ans[k++] = A[i];
    }
    for (size_t i = n - 1, t = k + 1; i > 0; --i) {
        while (k >= t && cross_product(ans[k - 2], ans[k - 1], A[i - 1]) <= 0)
            k--;
        ans[k++] = A[i - 1];
    }
    ans.resize(k - 1);
 
    return ans;
}
queue<Point> Tacke_unutra(vector<Point>& tacke, vector<Point>& omotac) {
    queue<Point> tacke_unutra;
    sort(omotac.begin(),omotac.end());
    int i = 0;
    for (const Point& p : tacke) {
        if (omotac[i] != p) {
            tacke_unutra.push(p);
        }
        else {
            i++;
        }
    }

    return tacke_unutra;
}
long long polygonArea(const vector<Point>& hull) {
    long long povrs = 0;
    int n = hull.size();
    for (int i = 0; i < n; i++) {
        int j = (i + 1) % n;
        povrs += hull[i].x * hull[j].y - hull[j].x * hull[i].y;
    }
    return abs(povrs) / 2;
}
long long area(long long x1, long long y1, long long x2, long long y2, long long x3, long long y3)
{
   return abs((x1*(y2-y3) + x2*(y3-y1)+ x3*(y1-y2))/2);
}
bool isInside(long long x1, long long y1, long long x2, long long y2, long long x3, long long y3, long long x, long long y)
{   
   long long A = area (x1, y1, x2, y2, x3, y3);
   long long A1 = area (x, y, x2, y2, x3, y3);
   long long A2 = area (x1, y1, x, y, x3, y3);
   long long A3 = area (x1, y1, x2, y2, x, y);
   return (A == A1 + A2 + A3);
}
int main(){
    ios_base::sync_with_stdio(false);
    ios::sync_with_stdio(false);
    cin.tie(0);
    int N;
    cin >> N;
    vector<Point> tacke(N);
    for(int i = 0; i < N; i++) {
        cin >> tacke[i].x >> tacke[i].y;
    }
    sort(tacke.begin(), tacke.end());
    vector<Point> omotac = convex_hull(tacke);
    long long Povrsina_celog = polygonArea(omotac);
    int om_pts = omotac.size();
    vector<vector<Point>> trouglovi(om_pts);
    for(int i = 0; i < om_pts;i++){
        trouglovi[i].push_back(omotac[i]);
        trouglovi[i].push_back(omotac[(i+1)%om_pts]);
        trouglovi[i].push_back(omotac[(i+2)%om_pts]);
    }
    queue<Point> tacke_unutra;
    tacke_unutra = Tacke_unutra(tacke, omotac);
    long long Porv_trougao;
    long long max_ = LLONG_MIN;
    queue<Point> tacke_temp;
    for(int i = 0; i < om_pts; i++) {
        tacke_temp = tacke_unutra;
        Porv_trougao = area(trouglovi[i][0].x, trouglovi[i][0].y, trouglovi[i][1].x,trouglovi[i][1].y, trouglovi[i][2].x, trouglovi[i][2].y);
        while(!tacke_temp.empty()){
            if(isInside(trouglovi[i][0].x, trouglovi[i][0].y, trouglovi[i][1].x,trouglovi[i][1].y, trouglovi[i][2].x, trouglovi[i][2].y,tacke_temp.front().x, tacke_temp.front().y)){
                trouglovi[i].push_back(tacke_temp.front());
            }
            tacke_temp.pop();
        }
        trouglovi[i].erase(trouglovi[i].begin());
        sort(trouglovi[i].begin(), trouglovi[i].end());
        max_ = max(max_,Porv_trougao-polygonArea(convex_hull(trouglovi[i])));
    }
    cout << Povrsina_celog - max_;
}